/*
 * Decompiled with CFR 0.152.
 */
package com.sicanet.solidez.solidez_queue_persons_back.controllers;

import com.sicanet.solidez.solidez_queue_persons_back.config.AuthRequest;
import com.sicanet.solidez.solidez_queue_persons_back.config.JwtUtils;
import com.sicanet.solidez.solidez_queue_persons_back.entities.User;
import com.sicanet.solidez.solidez_queue_persons_back.services.UserService;
import java.util.Collections;
import java.util.HashMap;
import javax.naming.AuthenticationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class LoginController {
    @Autowired
    private UserService userService;
    @Autowired
    private AuthenticationManager authenticationManager;
    @Autowired
    private JwtUtils jwtUtils;

    @PostMapping(value={"/login"})
    public ResponseEntity<?> login(@RequestBody AuthRequest authRequest) {
        try {
            User user = this.userService.findByUsername(authRequest.getUsername()).orElseThrow(() -> new AuthenticationException("Usuario No Encontrado"));
            this.authenticationManager.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)authRequest.getUsername(), (Object)authRequest.getPassword()));
            String token = this.jwtUtils.generateToken(authRequest.getUsername());
            HashMap<String, Object> response = new HashMap<String, Object>();
            response.put("id", user.getId());
            response.put("username", user.getUsername());
            response.put("bank_window", user.getBankWindow());
            response.put("status", user.getStatus());
            response.put("creation_date", user.getCreationDate());
            response.put("token", token);
            return ResponseEntity.ok(response);
        }
        catch (AuthenticationException e) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.UNAUTHORIZED).body(Collections.singletonMap("msg", "Credenciales inv\u00e1lidas"));
        }
    }

    @PostMapping(value={"/register"})
    public ResponseEntity<?> postLogin(@RequestBody User user) {
        try {
            if (this.userService.findByUsername(user.getUsername()).isPresent()) {
                return ResponseEntity.badRequest().body((Object)"Username already exists");
            }
            this.userService.save(user);
            return ResponseEntity.ok((Object)user);
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body((Object)("Error saving user: " + e.getMessage()));
        }
    }
}

