/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.service;

import com.sc.sicanet.migracion_sicanet.DTO.DomicilioDTO;
import com.sc.sicanet.migracion_sicanet.DTO.LaboralDTO;
import com.sc.sicanet.migracion_sicanet.DTO.PerfilTransaccionalDTO;
import com.sc.sicanet.migracion_sicanet.DTO.PersonaDTO;
import com.sc.sicanet.migracion_sicanet.DTO.SocioeconomicosDTO;
import com.sc.sicanet.migracion_sicanet.entity.CatDestinos;
import com.sc.sicanet.migracion_sicanet.entity.CatEstadoCivil;
import com.sc.sicanet.migracion_sicanet.entity.CatFormaPago;
import com.sc.sicanet.migracion_sicanet.entity.CatGeoEntidades;
import com.sc.sicanet.migracion_sicanet.entity.CatGeoLocalidades;
import com.sc.sicanet.migracion_sicanet.entity.CatGeoMunicipios;
import com.sc.sicanet.migracion_sicanet.entity.CatOrigenRecurso;
import com.sc.sicanet.migracion_sicanet.entity.CatPeriodos;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoAsentamiento;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoCasa;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoOcupacion;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoVialidad;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoViveZona;
import com.sc.sicanet.migracion_sicanet.entity.CatTipoVivienda;
import com.sc.sicanet.migracion_sicanet.entity.CodigosPostales;
import com.sc.sicanet.migracion_sicanet.entity.PerfilTransaccionalMontos;
import com.sc.sicanet.migracion_sicanet.entity.PldGiroActividad;
import com.sc.sicanet.migracion_sicanet.entity.PldPaises;
import com.sc.sicanet.migracion_sicanet.repository.CatDestinoRecursoRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatEstadoCivilRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatFormaPagoRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatGeoEntidadesRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatGeoLocalidadesRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatGeoMunicipiosRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatOrigenRecursoRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatPeriodosRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoAsentamientoRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoCasaRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoOcupacionRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoVialidadRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoViveZonaRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatTipoViviendaRepository;
import com.sc.sicanet.migracion_sicanet.repository.CodigosPostalesRepository;
import com.sc.sicanet.migracion_sicanet.repository.PerfilTransaccionalMontosRepository;
import com.sc.sicanet.migracion_sicanet.repository.PldGiroActividadRepository;
import com.sc.sicanet.migracion_sicanet.repository.PldPaisesRepository;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
public class Validaciones
implements Validator {
    @Autowired
    private PldPaisesRepository pldPaisesRepository;
    @Autowired
    private CatGeoEntidadesRepository catGeoEntidadesRepository;
    @Autowired
    private CatGeoLocalidadesRepository catGeoLocalidadesRepository;
    @Autowired
    private CatGeoMunicipiosRepository catGeoMunicipiosRepository;
    @Autowired
    private CatTipoViviendaRepository catTipoViviendaRepository;
    @Autowired
    private CatTipoCasaRepository catTipoCasaRepository;
    @Autowired
    private CatTipoViveZonaRepository catTipoViveZonaRepository;
    @Autowired
    private CatTipoAsentamientoRepository catTipoAsentamientoRepository;
    @Autowired
    private CatTipoVialidadRepository catTipoVialidadRepository;
    @Autowired
    private CatTipoOcupacionRepository catTipoOcupacionRepository;
    @Autowired
    private PldGiroActividadRepository pldGiroActividadRepository;
    @Autowired
    private CatEstadoCivilRepository catEstadoCivilRepository;
    @Autowired
    private CatDestinoRecursoRepository catDestinoRecursoRepository;
    @Autowired
    private CatOrigenRecursoRepository catOrigenRecursoRepository;
    @Autowired
    private CatPeriodosRepository catPeriodosRepository;
    @Autowired
    private CatFormaPagoRepository catFormaPagoRepository;
    @Autowired
    private PerfilTransaccionalMontosRepository perfilTransaccionalMontosRepository;
    @Autowired
    private CodigosPostalesRepository codigosPostalesRepository;

    public boolean supports(Class<?> clazz) {
        return PersonaDTO.class.equals(clazz);
    }

    public void validate(Object target, Errors errors) {
        PersonaDTO personaDTO = (PersonaDTO)target;
        this.validarInformacionPersona(personaDTO, errors);
        this.validarInformacionDomicilio(personaDTO.getDomicilio_personal(), errors, "domicilio_personal", "Domicilio Personal");
        this.validarInformacionLaboral(personaDTO.getLaboral(), errors);
        this.validarSocioeconomicosOrigen(personaDTO.getSocioeconomicos(), errors);
        this.validarSocioeconomicosDestino(personaDTO.getSocioeconomicos(), errors);
        this.validarPerfilTransaccional(personaDTO.getPerfil_transaccional(), errors);
    }

    private void validarInformacionPersona(PersonaDTO personaDTO, Errors errors) {
        this.validarEntidadNacimiento(personaDTO.getEntidad_nacimiento(), errors);
        this.validarPersonaRfcOrCurp(personaDTO.getRfc(), personaDTO.getCurp(), personaDTO.getTipo_persona(), errors, "");
        if (personaDTO.getTipo_persona().equals("F")) {
            this.validarFechaNacimiento(personaDTO.getFecha_nacimiento(), errors);
            this.validarPrefijoEstadoCivil(personaDTO.getEstado_civil(), errors);
            this.validarSexo(personaDTO.getSexo(), errors);
        } else {
            this.validarPersonaRfcOrCurp(personaDTO.getRepresentante_legal().getRfc(), personaDTO.getRepresentante_legal().getCurp(), personaDTO.getRepresentante_legal().getTipo_persona(), errors, "representante_legal.");
            this.validarFechaNacimiento(personaDTO.getRepresentante_legal().getFecha_nacimiento(), errors);
            this.validarSexo(personaDTO.getRepresentante_legal().getSexo(), errors);
            this.validarPrefijoEstadoCivil(personaDTO.getRepresentante_legal().getEstado_civil(), errors);
            this.validarInformacionDomicilio(personaDTO.getRepresentante_legal().getDomicilio_personal(), errors, "domicilio_personal", "Domicilio Personal");
        }
    }

    private void validarInformacionDomicilio(DomicilioDTO domicilioDTO, Errors errors, String nodo, String nodoMensaje) {
        Optional<CatTipoVialidad> catTipoVialidad;
        Optional<CatTipoAsentamiento> catTipoAsentamiento;
        Optional<CatTipoViveZona> catTipoViveZona;
        Optional<CatTipoCasa> catTipoCasa;
        Optional<CatGeoEntidades> catGeoEntidades;
        Optional<PldPaises> pldPaises = this.paises(domicilioDTO.getPais());
        if (pldPaises.isEmpty()) {
            errors.rejectValue(nodo + ".pais", "400", nodoMensaje + ": Pa\u00eds No V\u00e1lido.");
        }
        if ((catGeoEntidades = this.entidades(domicilioDTO.getEntidad())).isEmpty()) {
            errors.rejectValue(nodo + ".entidad", "400", nodoMensaje + ": Entidad No V\u00e1lida.");
        } else {
            Optional<CatGeoMunicipios> catGeoMunicipios = this.municipios(domicilioDTO.getMunicipio(), catGeoEntidades.get().getPkCatEntidad());
            if (catGeoMunicipios.isEmpty()) {
                errors.rejectValue(nodo + ".municipio", "400", nodoMensaje + ": Municipio No V\u00e1lido");
            } else {
                Optional<CatGeoLocalidades> catGeoLocalidades = this.localidades(domicilioDTO.getLocalidad(), catGeoMunicipios.get().getPkCatMunicipio(), catGeoEntidades.get().getPkCatEntidad());
                Optional<CodigosPostales> codigosPostales = this.codigosPostales(domicilioDTO.getCp(), catGeoEntidades.get().getPkCatEntidad(), catGeoMunicipios.get().getPkCatMunicipio());
                if (catGeoEntidades.isEmpty()) {
                    errors.rejectValue(nodo + ".localidad", "400", nodoMensaje + ": Localidad No V\u00e1lida");
                }
                if (codigosPostales.isEmpty()) {
                    errors.rejectValue(nodo + ".cp", "400", nodoMensaje + ": C\u00f3digo Postal No V\u00e1lido");
                }
            }
        }
        Optional<CatTipoVivienda> catTipoVivienda = this.catTipoVivienda(domicilioDTO.getTipo_vivienda());
        if (catTipoVivienda.isEmpty()) {
            errors.rejectValue(nodo + ".tipo_vivienda", "400", nodoMensaje + ": Tipo Vivienda No V\u00e1lido");
        }
        if ((catTipoCasa = this.catTipoCasa(domicilioDTO.getTipo_casa())).isEmpty()) {
            errors.rejectValue(nodo + ".tipo_casa", "400", nodoMensaje + ": Tipo Casa No V\u00e1lido");
        }
        if ((catTipoViveZona = this.catTipoViveZona(domicilioDTO.getZona_residencia())).isEmpty()) {
            errors.rejectValue(nodo + ".zona_residencia", "400", nodoMensaje + ": Zona Residencia No V\u00e1lida");
        }
        if ((catTipoAsentamiento = this.catTipoAsentamiento(domicilioDTO.getTipo_asentamiento())).isEmpty()) {
            errors.rejectValue(nodo + ".tipo_asentamiento", "400", nodoMensaje + ": Tipo Asentamiento No V\u00e1lido");
        }
        if ((catTipoVialidad = this.catTipoVialidad(domicilioDTO.getTipo_vialidad())).isEmpty()) {
            errors.rejectValue(nodo + ".tipo_vialidad", "400", nodoMensaje + ": Tipo Vialidad No V\u00e1lido");
        }
        if (domicilioDTO.getUuid() != null && !domicilioDTO.getUuid().isEmpty() && !domicilioDTO.getUuid().matches("^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$")) {
            errors.rejectValue(nodo + ".uuid", "400", "La clave UUID No Tiene Un Formato V\u00e1lido.");
        }
    }

    private void validarInformacionLaboral(LaboralDTO laboralDTO, Errors errors) {
        Optional<PldGiroActividad> pldGiroActividad;
        String nodo_laboral = "laboral";
        Optional<CatTipoOcupacion> catTipoOcupacion = this.catTipoOcupacionRepository.findByDescripcion(laboralDTO.getTipo_ocupacion());
        if (catTipoOcupacion.isEmpty()) {
            errors.rejectValue(nodo_laboral + ".tipo_ocupacion", "400", "Tipo De Ocupaci\u00f3n No V\u00e1lida");
        }
        if ((pldGiroActividad = this.pldGiroActividadRepository.findByPkGiroActividad(laboralDTO.getActividad_economica())).isEmpty()) {
            errors.rejectValue(nodo_laboral + ".actividad_economica", "400", "Actividad Econ\u00f3mica No V\u00e1lida");
        }
        this.validarInformacionDomicilio(laboralDTO.getDomicilio_laboral(), errors, nodo_laboral + ".domicilio_laboral", "Domicilio Laboral");
    }

    private void validarSocioeconomicosDestino(SocioeconomicosDTO pldCatPersonasRecursoDestinoDTO, Errors errors) {
        String nodo = "socioeconomicos";
        this.validarDestinoRecurso(pldCatPersonasRecursoDestinoDTO.getDestino_recurso(), errors, nodo);
    }

    private void validarSocioeconomicosOrigen(SocioeconomicosDTO pldCatPersonasRecursoOrigenDTO, Errors errors) {
        String nodo = "socioeconomicos";
        this.validarOrigenRecurso(pldCatPersonasRecursoOrigenDTO.getOrigen_recurso(), errors, nodo);
    }

    private void validarPerfilTransaccional(PerfilTransaccionalDTO perfilTransaccionalDTO, Errors errors) {
        String nodo = "perfil_transaccional";
        this.validarFormaDePago(perfilTransaccionalDTO.getForma_pago(), errors, nodo);
        this.validarPeriodos(perfilTransaccionalDTO.getPeriodicidad(), errors, nodo);
        this.validarDisponibilidadMensual(perfilTransaccionalDTO.getDisponibilidad_mensual(), errors, nodo);
    }

    private void validarOrigenRecurso(String descripcion, Errors errors, String nodo) {
        Optional<CatOrigenRecurso> catOrigenRecurso = this.catOrigenRecurso(descripcion);
        if (catOrigenRecurso.isEmpty()) {
            errors.rejectValue(nodo + ".origen_recurso", "400", "El Origen De Recurso No Es V\u00e1lido");
        }
    }

    private void validarDestinoRecurso(String destino, Errors errors, String nodo) {
        Optional<CatDestinos> catDestinos = this.catDestinos(destino);
        if (catDestinos.isEmpty()) {
            errors.rejectValue(nodo + ".destino_recurso", "400", "El Destino De Recurso No Es V\u00e1lido");
        }
    }

    private void validarFormaDePago(List<String> forma, Errors errors, String nodo) {
        for (String _forma : forma) {
            Optional<CatFormaPago> catFormaPago = this.catFormaPago(_forma.trim());
            if (!catFormaPago.isEmpty()) continue;
            errors.rejectValue(nodo + ".forma_pago", "400", "La Forma De Pago No Es V\u00e1lida");
        }
    }

    private void validarPeriodos(String periodo, Errors errors, String nodo) {
        Optional<CatPeriodos> catPeriodos = this.catPeriodos(periodo);
        if (catPeriodos.isEmpty()) {
            errors.rejectValue(nodo + ".periodicidad", "400", "El Periodo De Pago No Es V\u00e1lida");
        }
    }

    private void validarDisponibilidadMensual(String descripcion, Errors errors, String nodo) {
        Optional<PerfilTransaccionalMontos> perfilTransaccionalMontos = this.perfilTransaccionalMontos(descripcion);
        if (perfilTransaccionalMontos.isEmpty()) {
            errors.rejectValue(nodo + ".disponibilidad_mensual", "400", "La Disponibilidad Mensual No Es V\u00e1lida");
        }
    }

    private void validarPersonaRfcOrCurp(String rfc, String curp, String tipoPersona, Errors errors, String nodo) {
        String regex_rfc;
        String regex_curp = "^[A-Z]{4}[0-9]{6}[HM]{1}[A-Z]{5}[A-Z0-9]{2}$";
        String string = regex_rfc = tipoPersona.equals("F") ? "^[A-Z\u00d1&]{4}[0-9]{6}[A-Z0-9]{3}$" : "^[A-Z\u00d1&]{3}[0-9]{6}[A-Z0-9]{3}$";
        if (!rfc.matches(regex_rfc) && rfc != null && !rfc.isEmpty()) {
            errors.rejectValue(nodo + "rfc", "400", "El RFC No Tiene Un Formato V\u00e1lido.");
        }
        if (tipoPersona.equals("F") && !curp.matches(regex_curp)) {
            errors.rejectValue(nodo + "curp", "400", "La CURP No Tiene Un Formato V\u00e1lido.");
        }
        if (!tipoPersona.equals("F") && !tipoPersona.equals("M")) {
            errors.rejectValue(nodo + "tipo_persona", "400", "Tipo De Persona No V\u00e1lido: El Tipo De Persona Debe Ser 'F', 'M', 'F\u00cdSICA' o 'MORAL'");
        }
    }

    private void validarSexo(String sexo, Errors errors) {
        if (sexo == null) {
            errors.rejectValue("sexo", "400", "El Campo 'Sexo' Es Requerido");
        } else if (sexo != null && !sexo.matches("^[FM]")) {
            errors.rejectValue("sexo", "400", "El Tipo De Persona Debe Ser 'F' (FEMENINO) o 'M' (MASCULINO)");
        }
    }

    private void validarFechaNacimiento(LocalDate fechaNacimiento, Errors errors) {
        long edad = ChronoUnit.YEARS.between(fechaNacimiento, LocalDate.now());
        if (edad < 18L) {
            errors.rejectValue("fecha_nacimiento", "400", "El Cliente No Puede Ser Menor De 18 A\u00f1os");
        }
    }

    private void validarEntidadNacimiento(String entidad, Errors errors) {
        Optional<CatGeoEntidades> catGeoEntidades;
        if (entidad == null || entidad.isBlank()) {
            errors.rejectValue("entidad_nacimiento", "400", "La Entidad De Nacimiento No Puede Estar Vac\u00eda.");
        }
        if ((catGeoEntidades = this.entidades(entidad)).isEmpty()) {
            errors.rejectValue("entidad_nacimiento", "400", "Entidad De Nacimiento No V\u00e1lida.");
        }
    }

    private void validarPrefijoEstadoCivil(String prefijoBuro, Errors errors) {
        Optional<CatEstadoCivil> catEstadoCivil = this.catEstadoCivil(prefijoBuro);
        if (catEstadoCivil.isEmpty()) {
            errors.rejectValue("estado_civil", "400", "Estado Civil No V\u00e1lido, Ingrese El Prefijo Correcto");
        }
    }

    private Optional<PldPaises> paises(String pais) {
        return this.pldPaisesRepository.findByNombre(pais);
    }

    private Optional<CatGeoEntidades> entidades(String entidad) {
        return this.catGeoEntidadesRepository.findByEntidad(entidad);
    }

    private Optional<CatGeoMunicipios> municipios(String municipio, int entidad) {
        return this.catGeoMunicipiosRepository.findByMunicipioAndFkCatEntidad(municipio, entidad);
    }

    private Optional<CatGeoLocalidades> localidades(String localidad, int municipio, int entidad) {
        return this.catGeoLocalidadesRepository.findByLocalidadAndFkCatMunicipioAndFkCatEntidad(localidad, municipio, entidad);
    }

    private Optional<CatTipoVivienda> catTipoVivienda(String tipoVivienda) {
        return this.catTipoViviendaRepository.findByDescripcion(tipoVivienda);
    }

    private Optional<CatTipoCasa> catTipoCasa(String tipoCasa) {
        return this.catTipoCasaRepository.findByTipoCasa(tipoCasa);
    }

    private Optional<CatTipoViveZona> catTipoViveZona(String zonaResidencia) {
        return this.catTipoViveZonaRepository.findByDescripcion(zonaResidencia);
    }

    private Optional<CatTipoAsentamiento> catTipoAsentamiento(String tipoAsentamiento) {
        return this.catTipoAsentamientoRepository.findByDescripcion(tipoAsentamiento);
    }

    private Optional<CatTipoVialidad> catTipoVialidad(String tipoVialidad) {
        return this.catTipoVialidadRepository.findByTipoVialidad(tipoVialidad);
    }

    private Optional<CodigosPostales> codigosPostales(String codigoPostal, int fkCatEntidad, int fkCatMunicipio) {
        return this.codigosPostalesRepository.findByCodigoPostalAndFkCatEntidadAndFkCatMunicipio(codigoPostal, fkCatEntidad, fkCatMunicipio);
    }

    private Optional<CatEstadoCivil> catEstadoCivil(String prefijoBuro) {
        return this.catEstadoCivilRepository.findByPrefijoBuro(prefijoBuro);
    }

    private Optional<CatDestinos> catDestinos(String destino) {
        return this.catDestinoRecursoRepository.findByDestino(destino);
    }

    private Optional<CatOrigenRecurso> catOrigenRecurso(String descripcion) {
        return this.catOrigenRecursoRepository.findByDescripcion(descripcion);
    }

    private Optional<CatPeriodos> catPeriodos(String periodo) {
        return this.catPeriodosRepository.findByPeriodo(periodo);
    }

    private Optional<CatFormaPago> catFormaPago(String forma) {
        return this.catFormaPagoRepository.findByForma(forma);
    }

    private Optional<PerfilTransaccionalMontos> perfilTransaccionalMontos(String descripcion) {
        return this.perfilTransaccionalMontosRepository.findByDescripcion(descripcion);
    }
}

