/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.service;

import com.sc.sicanet.migracion_sicanet.DTO.RepresentanteLegalDTO;
import com.sc.sicanet.migracion_sicanet.entity.CatEstadoCivil;
import com.sc.sicanet.migracion_sicanet.entity.CatGeoEntidades;
import com.sc.sicanet.migracion_sicanet.entity.Persona;
import com.sc.sicanet.migracion_sicanet.entity.RepresentanteLegal;
import com.sc.sicanet.migracion_sicanet.repository.CatEstadoCivilRepository;
import com.sc.sicanet.migracion_sicanet.repository.CatGeoEntidadesRepository;
import com.sc.sicanet.migracion_sicanet.repository.RepresentateLegalRepository;
import com.sc.sicanet.migracion_sicanet.service.PersonaService;
import com.sc.sicanet.migracion_sicanet.service.RepresentanteLegalService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RepresentanteLegalServiceImpl
implements RepresentanteLegalService {
    @Autowired
    private RepresentateLegalRepository representateLegalRepository;
    @Autowired
    private CatGeoEntidadesRepository catGeoEntidadesRepository;
    @Autowired
    private CatEstadoCivilRepository catEstadoCivilRepository;
    @Autowired
    private PersonaService personaService;
    @PersistenceContext
    private EntityManager entityManager;

    @Override
    public RepresentanteLegal guardarRepresentante(RepresentanteLegal representanteLegal) {
        return (RepresentanteLegal)this.representateLegalRepository.save(representanteLegal);
    }

    @Override
    public Optional<RepresentanteLegal> consultarRepresentanteLegal(Persona persona) {
        return this.representateLegalRepository.findByPersona(persona);
    }

    @Override
    public RepresentanteLegal convertirDatos(RepresentanteLegalDTO representanteLegalDTO, Persona persona) {
        Optional<RepresentanteLegal> representanteLegalExistente;
        LocalDateTime fechaActual = LocalDateTime.now();
        Optional<CatGeoEntidades> catGeoEntidades = this.catGeoEntidadesRepository.findByEntidad(representanteLegalDTO.getEntidad_nacimiento());
        Optional<CatEstadoCivil> catEstadoCivil = this.catEstadoCivilRepository.findByPrefijoBuro(representanteLegalDTO.getEstado_civil());
        Persona personaRepresentante = new Persona(fechaActual, representanteLegalDTO.getTipo_persona(), representanteLegalDTO.getNombre(), representanteLegalDTO.getApaterno(), representanteLegalDTO.getAmaterno(), catGeoEntidades.isPresent() ? catGeoEntidades.get().getPkCatEntidad() : 0, representanteLegalDTO.getLugar_nacimiento(), representanteLegalDTO.getFecha_nacimiento(), representanteLegalDTO.getSexo(), representanteLegalDTO.getRfc(), representanteLegalDTO.getCurp(), catEstadoCivil.isPresent() ? catEstadoCivil.get().getPrefijoBuro() : "", "", 0, "", "", "", "", 0, 0, 1, "API Migracion", "A", 1);
        personaRepresentante.setFechaControl(fechaActual);
        personaRepresentante.setFechaRegistro(fechaActual);
        Optional<Persona> personaExistente = this.personaService.consultaPersonas(personaRepresentante);
        if (!personaExistente.isEmpty()) {
            personaRepresentante.setPkPersona(personaExistente.get().getPkPersona());
            personaRepresentante.setFechaRegistro(personaExistente.get().getFechaRegistro());
            personaRepresentante.setFechaControl(personaExistente.get().getFechaModificacion());
        }
        RepresentanteLegal representanteLegal = new RepresentanteLegal(fechaActual, personaRepresentante, "[]", 1, "API Migracion", "A", 1, persona);
        representanteLegal.setFechaControl(fechaActual);
        representanteLegal.setFechaRegistro(fechaActual);
        if (persona.getPkPersona() != 0 && !(representanteLegalExistente = this.consultarRepresentanteLegal(persona)).isEmpty()) {
            representanteLegal.setPkRepresentanteLegal(representanteLegalExistente.get().getPkRepresentanteLegal());
            representanteLegal.setFechaControl(representanteLegalExistente.get().getFechaControl());
            representanteLegal.setFechaRegistro(representanteLegalExistente.get().getFechaRegistro());
        }
        return representanteLegal;
    }
}

