/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.service;

import com.sc.sicanet.migracion_sicanet.DTO.CatContactoDTO;
import com.sc.sicanet.migracion_sicanet.entity.CatContacto;
import com.sc.sicanet.migracion_sicanet.entity.Persona;
import com.sc.sicanet.migracion_sicanet.repository.CatContactoRepository;
import com.sc.sicanet.migracion_sicanet.service.ContactoService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.LocalDateTime;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ContactoServiceImpl
implements ContactoService {
    @Autowired
    private CatContactoRepository catContactoRepository;
    @PersistenceContext
    private EntityManager entityManager;
    @Value(value="${config.contacto.fktipocontactocelular}")
    private int fkCatTipoContactoCelular;

    @Override
    public CatContacto guardarContacto(CatContacto catContacto) {
        return (CatContacto)this.catContactoRepository.save(catContacto);
    }

    @Override
    public Optional<CatContacto> consultaContacto(Persona persona) {
        return this.catContactoRepository.findByPersonaAndEstatus(persona, "A");
    }

    @Override
    public CatContacto convertirDatosDeContacto(CatContactoDTO catContactoDTO, Persona persona) {
        Optional<CatContacto> catContactoExistente;
        LocalDateTime fechaActual = LocalDateTime.now();
        CatContacto catContacto = new CatContacto(fechaActual, "", catContactoDTO.getTelefono_celular(), "", this.fkCatTipoContactoCelular, 0, 0, "API Migracion", "A", 1);
        catContacto.setFechaControl(fechaActual);
        catContacto.setFechaRegistro(fechaActual);
        if (persona.getPkPersona() != 0 && !(catContactoExistente = this.consultaContacto(persona)).isEmpty()) {
            catContacto.setPkCatContacto(catContactoExistente.get().getPkCatContacto());
            catContacto.setFechaControl(catContactoExistente.get().getFechaControl());
            catContacto.setFechaRegistro(catContactoExistente.get().getFechaRegistro());
        }
        return catContacto;
    }
}

