/*
 * Decompiled with CFR 0.152.
 */
package com.sc.sicanet.migracion_sicanet.controller;

import com.sc.sicanet.migracion_sicanet.DTO.PersonaDTO;
import com.sc.sicanet.migracion_sicanet.entity.Persona;
import com.sc.sicanet.migracion_sicanet.response.ErrorResponse;
import com.sc.sicanet.migracion_sicanet.response.StandardResponse;
import com.sc.sicanet.migracion_sicanet.service.MigracionService;
import com.sc.sicanet.migracion_sicanet.service.PersonaService;
import com.sc.sicanet.migracion_sicanet.service.Validaciones;
import jakarta.validation.Valid;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/personas"})
public class MigracionController {
    private final MigracionService migracionService;
    private final Validaciones validaciones;
    @Autowired
    private PersonaService personaService;

    public MigracionController(MigracionService migracionService, Validaciones validaciones) {
        this.migracionService = migracionService;
        this.validaciones = validaciones;
    }

    @GetMapping(produces={"application/json"})
    public ResponseEntity<List<Persona>> findAll() {
        List<Persona> allPersonas = this.migracionService.findAll();
        return new ResponseEntity(allPersonas, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(path={"/{id}"}, produces={"application/json"})
    public ResponseEntity<Persona> findById(@PathVariable(value="id") int id) {
        Optional<Persona> persona = this.migracionService.findById(id);
        return persona.map(value -> new ResponseEntity(value, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> ResponseEntity.notFound().build());
    }

    @PostMapping
    public ResponseEntity<?> migrateData(@Valid @RequestBody PersonaDTO personaDTO, Errors errors) {
        this.validaciones.validate(personaDTO, errors);
        List<ErrorResponse> errores = ErrorResponse.validateError(errors);
        if (!errores.isEmpty()) {
            return ResponseEntity.badRequest().body((Object)new StandardResponse(400, "Errores de validaci\u00f3n", errores));
        }
        Map<String, String> resultadoMigracion = this.migracionService.migracion(personaDTO);
        return ResponseEntity.ok((Object)new StandardResponse(Integer.parseInt(resultadoMigracion.get("code")), resultadoMigracion.get("mensaje"), resultadoMigracion.get("referenciaAcreditado"), resultadoMigracion.get("nombreAcreditado"), resultadoMigracion.get("uuidDomicilioPersonal"), resultadoMigracion.get("uuidDomicilioLaboral")));
    }
}

